/// <reference path="http://localhost/JSLib_Original/jquery-1.7.2-vsdoc.js"/>
/// <reference path="http://localhost/JSLib_Original/jquery-ui-1.8.21.custom.js"/>
/// <reference path="/njres/lang/ja_JP/js/resource.js" />

$.extend($.support, {
    // input イベントを使用できるか？
    'inputEvent': typeof document.createElement('INPUT').oninput != 'undefined'
});

/// <summary>共通処理</summary>
$.extend(neo, {
    _testRegExpSplitResult: null,
    isSet: function (value, options) {
        /// <summary>※undefined, nullの場合のみfalseを返す。optionsでfalseを返す条件を変更できる</summary>
        /// <param name="options" type="Object">undefined, null, NaN, zero, blank(空文字列), falseのときの戻り値</param>
        /// <returns type="Boolean" />
        var typeName = typeof (value);
        var o = !!options ? options : {};
        if (typeName == 'undefined') {
            return !!o['undefined'];
        } else if (value === null) {
            return !!o['null'];
        } else if (typeName == 'number' && isNaN(value)) {
            return typeof o['NaN'] == 'undefined' || !!o['NaN'];
        } else if (value === 0) {
            return typeof o['zero'] == 'undefined' || !!o['zero'];
        } else if (value === "") {
            return typeof o['blank'] == 'undefined' || !!o['blank'];
        } else if (value === false) {
            return typeof o['false'] == 'undefined' || !!o['false'];
        }
        return true;
    },

    supportStyle: function (name, value) {
        /// <summary>CSSのプロパティが対応されているかどうかを取得する。</summary>
        /// <param name="name" type="String">プロパティ名(camelCase)</param>
        /// <param name="value" type="String">CSSプロパティ値(省略すると検証しない) NVP200_0014462</param>
        /// <returns type="Boolean" />
        var style = document.createElement('DIV').style;
        var vendors = ['ms', 'Moz', 'webkit'];
        // そのまま定義 
        if (typeof style[name] != 'undefined') {
            return this._supportStyleValue(style, name, value); // NVP200_0014462
        }
        // vendor prefix付きで定義 
        var capName = name.replace(/^\w/, function (c) { return c.toUpperCase(); });
        for (var i = 0; i < vendors.length; i++) {
            if (typeof style[vendors[i] + capName] != 'undefined') {
                return this._supportStyleValue(style, vendors[i] + capName, value); // NVP200_0014462
            }
        }

        return false;
    },

    regExpSplit: function (text, expression, limit) {
        /// <summary>String::split()のIE 8以下のバグ回避版</summary>
        /// <param name="text" type="String">文字列</param>
        /// <param name="expression" type="RegExp">正規表現</param>
        /// <param name="limit" type="Number">結果の要素数の上限</param>
        if ($.type(expression) != 'regexp' || this._testRegExpSplit()) {
            return String(text).split(expression, limit);
        }
        var result = [], index = 0, flags = expression.ignoreCase ? 'ig' : 'g';
        text.replace(new RegExp(expression.source, flags), function (matchedAll) {
            var curr = arguments[arguments.length - 2];
            // 開始位置から分割表現の前までを追加
            result.push(text.substring(index, curr));
            // キャプチャを追加
            for (var i = 1; i < arguments.length - 2; i++) {
                result.push(arguments[i]);
            }
            // 分割表現の後を開始位置に
            index = curr + matchedAll.length;
        });
        // 開始位置から最後までを追加
        result.push(text.substring(index));

        if (typeof (limit) == 'number' && limit < result.length) {
            result = result.slice(0, limit);
        }
        return result;
    },

    //- Private ---------------------------------------------------------------
    _supportStyleValue: function (style, name, value) {
        /// <summary>CSSの名前と値を検証する NVP200_0014462</summary>
        /// <param name="style" type="Style">Style</param>
        /// <param name="name" type="String">CSSプロパティ名</param>
        /// <param name="value" type="String">CSSプロパティ値(省略すると検証しない)</param>
        /// <returns type="Boolean" />
        if (typeof value != 'undefined' && value !== null) {
            try {
                style[name] = value;
                return style[name] == value;
            } catch (err) {
                return false;
            }
        }
        return true;
    },

    _testRegExpSplit: function () {
        /// <summary>String::split()の動作検証: IE のバグ関連</summary>
        /// <returns type="Boolean" />
        if (typeof this._testRegExpSplitResult != 'boolean') {
            this._testRegExpSplitResult = 'a'.split(/(a)/).length == 3;
        }
        return this._testRegExpSplitResult;
    },

    decodeURIComponent: function (value) {
        /// <summary>URLの部分文字列をデコードする(空白変換以外decodeURIComponentと同じ)。 NVP300_0023093</summary>
        /// <param name="value" type="String">URLの部分文字列</param>
        /// <returns type="String" />
        return decodeURIComponent(value.replace(/\+/g, ' '));
    },

    parseQueryString: function (query) {
        /// <summary>クエリー文字列をオブジェクトにする。NVP300_0023093</summary>
        /// <param name="query" type="String">クエリー文字列</param>
        /// <returns type="Object" />
        var self = this, params = {}, entries = query.split('&');
        $.each(entries, function (i, entry) {
            var kv = entry.split('='), key, value, type;
            if (kv.length > 0 && kv[0] != '') {
                key = self.decodeURIComponent(kv[0]);
                value = kv.length > 1 ? self.decodeURIComponent(kv[1]) : null;

                // キーに対する値が1つならそのまま、2つ以上なら配列にする
                type = $.type(params[key]);
                if (type == 'array') {
                    params[key].push(value);
                } else if (type != 'undefined') {
                    params[key] = [params[key], value];
                } else {
                    params[key] = value;
                }
            }
        });

        return params;
    },
});

